{ i2c_test - Example main program to read and write to a 24LC65 EEprom

  Copyright (C) 2003- John Coppens

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
}

program I2C_Test;

uses
  i2c;

const
  PPport = $378;
  EEaddr = $A0;

type
  EEprom = object (i2c_port)
    EEaddr: byte;
    procedure Initialize(Addr: word; EEad: byte);
    function Byte_Written(addr: word; b: byte): boolean;
    function Byte_Read(addr: word; var b: byte): boolean;
    function Security_Read(var b1, b2: byte): boolean;
  end;

var
  EEP: EEprom;

procedure EEprom.Initialize(Addr: word; EEad: byte);
begin
  inherited Initialize(Addr);
  EEaddr := EEad;
end;

function EEprom.Byte_Written(addr: word; b: byte): boolean;
begin
  Byte_Written := false;
  Start_Cond;
  if Byte_Sent(EEaddr) then
    if Byte_Sent(addr shr 8) then
      if Byte_Sent(addr and $FF) then
        if Byte_Sent(b) then
          Byte_Written := true;
  Stop_Cond;
end;

function EEprom.Byte_Read(Addr: word; var b: byte): boolean;
begin
  Byte_Read := false;
  Start_Cond;
  if Byte_Sent(EEaddr) then
    if Byte_Sent(Addr shr 8) then
      if Byte_Sent(Addr and $FF) then begin
        Start_Cond;
        if Byte_Sent(EEaddr or READ_FLG) then begin
          b := Receive_Byte(false);
          Byte_Read := true;
        end;
      end;
  Stop_Cond;
end;

function EEprom.Security_read(var b1, b2: byte): boolean;
begin
  Security_Read := false;

  Start_Cond;
  if Byte_Sent(EEaddr) then
    if Byte_Sent($80) then
      if Byte_Sent($00) then
        if Byte_Sent($C0) then begin
          b1 := Receive_Byte(TRUE);
          b2 := Receive_Byte(FALSE);
          Security_Read := TRUE;
        end;
  Stop_Cond;
end;

var
  b: byte;

begin
  EEP.Initialize(PPport, $A0);
  if EEP.Byte_Written(123, 111) then
    writeln('Ok')
  else begin
    writeln('Error writing');
    halt(1);
  end;

  repeat
  until EEP.Poll_Available(EEaddr);

  if EEP.Byte_Read(123, b) then
    writeln(b)
  else
    writeln('Error reading');
end.
